<?php
// -------------------------------------------------
// ARQUIVO DE CONFIGURAÇÃO & BACKEND (INTACTO)
// -------------------------------------------------
define('DB_HOST', 'localhost');
define('DB_USER', 'smaisdigital_user_onboarding'); 
define('DB_PASS', 'Admin@99@SMAIS'); 
define('DB_NAME', 'smaisdigital_onboarding'); 
define('N8N_WEBHOOK_URL', 'https://seu-dominio-n8n.com/webhook/ID-DO-WEBHOOK');

date_default_timezone_set('America/Sao_Paulo');
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) { die("Conexão falhou: " . $conn->connect_error); }
$conn->set_charset("utf8mb4");

// -------------------------------------------------
// API - MARCAR COMO FEITO
// -------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    $input = json_decode(file_get_contents('php://input'), true);
    $client_id = $input['client_id'] ?? 0;
    $task_id = $input['task_id'] ?? 0;

    if ($client_id > 0 && $task_id > 0) {
        $stmt_verify = $conn->prepare("SELECT responsible FROM tasks WHERE id = ?");
        $stmt_verify->bind_param("i", $task_id);
        $stmt_verify->execute();
        $res_verify = $stmt_verify->get_result();
        $task_info = $res_verify->fetch_assoc();

        if ($task_info && $task_info['responsible'] === 'client') {
            $check = $conn->prepare("SELECT id FROM client_task_progress WHERE client_id = ? AND task_id = ?");
            $check->bind_param("ii", $client_id, $task_id);
            $check->execute();
            
            if ($check->get_result()->num_rows == 0) {
                $now = date('Y-m-d H:i:s');
                $ins = $conn->prepare("INSERT INTO client_task_progress (client_id, task_id, completed_at) VALUES (?, ?, ?)");
                $ins->bind_param("iis", $client_id, $task_id, $now);
                
                if ($ins->execute()) {
                    // Webhook silencioso
                    $c_name = $conn->query("SELECT name FROM clients WHERE id = $client_id")->fetch_object()->name;
                    $t_name = $conn->query("SELECT name FROM tasks WHERE id = $task_id")->fetch_object()->name;
                    $ctx = stream_context_create(['http' => ['method'=>'POST', 'header'=>"Content-Type: application/json\r\n", 'content'=>json_encode(['client'=>$c_name, 'task'=>$t_name, 'date'=>$now]), 'ignore_errors'=>true]]);
                    @file_get_contents(N8N_WEBHOOK_URL, false, $ctx);

                    echo json_encode(['success' => true, 'completed_at' => date('d/m/Y H:i', strtotime($now))]);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Erro SQL']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'Já concluída']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Ação restrita']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    }
    exit;
}

// -------------------------------------------------
// RENDERIZAÇÃO DA PÁGINA
// -------------------------------------------------
$client_slug = $_GET['client'] ?? '';
if (empty($client_slug)) die("Cliente não informado na URL.");

$stmt = $conn->prepare("SELECT id, name FROM clients WHERE client_slug = ?");
$stmt->bind_param("s", $client_slug);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows == 0) die("Cliente não encontrado.");
$client = $res->fetch_assoc();
$client_id = $client['id'];

// Buscar tarefas e progresso
$sql = "
    SELECT t.*, p.completed_at 
    FROM tasks t 
    LEFT JOIN client_task_progress p ON t.id = p.task_id AND p.client_id = $client_id
    ORDER BY t.week ASC, t.order_index ASC
";
$query_tasks = $conn->query($sql);

$weeks_data = [];
$total_client_tasks = 0;
$total_client_completed = 0;

while ($row = $query_tasks->fetch_assoc()) {
    $wk = $row['week'];
    $topic = $row['topic']; 
    
    if (!isset($weeks_data[$wk])) {
        $weeks_data[$wk] = [
            'title' => $row['week_title'],
            'topics' => []
        ];
    }
    
    if (!isset($weeks_data[$wk]['topics'][$topic])) {
        $weeks_data[$wk]['topics'][$topic] = [];
    }

    if ($row['responsible'] === 'client') {
        $total_client_tasks++;
        if ($row['completed_at']) $total_client_completed++;
    }

    $weeks_data[$wk]['topics'][$topic][] = $row;
}

$percentage = ($total_client_tasks > 0) ? round(($total_client_completed / $total_client_tasks) * 100) : 0;
?>

<!DOCTYPE html>
<html lang="pt-BR" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Operations Center | <?php echo htmlspecialchars($client['name']); ?></title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&family=Rajdhani:wght@500;600;700&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                        hud: ['Rajdhani', 'sans-serif'],
                    },
                    colors: {
                        ops: {
                            950: '#022c22', // Fundo ultra dark
                            900: '#064e3b', // Paineis
                            800: '#065f46', // Bordas
                            500: '#0F9433', // Principal
                            400: '#34d399', // Brilho
                            gold: '#fbbf24' // Rank/Troféu
                        }
                    },
                    backgroundImage: {
                        'grid-pattern': "linear-gradient(to right, #065f46 1px, transparent 1px), linear-gradient(to bottom, #065f46 1px, transparent 1px)",
                    },
                    animation: {
                        'scanline': 'scanline 8s linear infinite',
                        'pulse-border': 'pulse-border 2s infinite',
                    },
                    keyframes: {
                        scanline: {
                            '0%': { transform: 'translateY(-100%)' },
                            '100%': { transform: 'translateY(100%)' }
                        },
                        'pulse-border': {
                            '0%, 100%': { borderColor: 'rgba(16, 185, 129, 0.3)' },
                            '50%': { borderColor: 'rgba(16, 185, 129, 0.8)' },
                        }
                    }
                }
            }
        }
    </script>

    <style>
        /* Custom Scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: #022c22; }
        ::-webkit-scrollbar-thumb { background: #065f46; border-radius: 0px; }
        ::-webkit-scrollbar-thumb:hover { background: #10b981; }

        body {
            background-color: #022c22;
            color: #e2e8f0;
            overflow-x: hidden;
        }

        /* Grid Tático no fundo */
        .tactical-grid {
            background-size: 40px 40px;
            background-image: radial-gradient(circle, #064e3b 1px, transparent 1px);
            opacity: 0.2;
            position: fixed;
            inset: 0;
            z-index: -1;
        }

        .glass-ops {
            background: rgba(6, 78, 59, 0.3); /* Verde escuro transparente */
            backdrop-filter: blur(8px);
            border: 1px solid rgba(52, 211, 153, 0.1);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.3);
        }

        .card-mission {
            background: linear-gradient(180deg, rgba(6, 78, 59, 0.2) 0%, rgba(2, 44, 34, 0.8) 100%);
            border: 1px solid rgba(6, 95, 70, 0.5);
            position: relative;
            overflow: hidden;
        }
        
        /* Canto cortado estilo Sci-Fi */
        .cut-corner {
            clip-path: polygon(
                0 0, 
                100% 0, 
                100% calc(100% - 15px), 
                calc(100% - 15px) 100%, 
                0 100%
            );
        }

        .btn-tactical {
            background: linear-gradient(45deg, #064e3b 0%, #065f46 100%);
            border: 1px solid #10b981;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.2s;
            position: relative;
            overflow: hidden;
        }
        
        .btn-tactical::before {
            content: '';
            position: absolute;
            top: 0; left: -100%;
            width: 100%; height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: 0.5s;
        }
        
        .btn-tactical:hover::before { left: 100%; }
        .btn-tactical:hover { 
            background: #10b981; 
            color: #022c22;
            box-shadow: 0 0 15px rgba(16, 185, 129, 0.5);
        }

        .text-glow { text-shadow: 0 0 10px rgba(52, 211, 153, 0.4); }

        /* Efeito de Scanline */
        .scan-overlay {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: linear-gradient(to bottom, rgba(255,255,255,0), rgba(255,255,255,0) 50%, rgba(0,0,0,0.1) 50%, rgba(0,0,0,0.1));
            background-size: 100% 4px;
            pointer-events: none;
            z-index: 999;
            opacity: 0.15;
        }

        .rank-badge {
            background: linear-gradient(to right, #fbbf24, #d97706);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
</head>
<body class="antialiased min-h-screen pb-32 selection:bg-ops-500 selection:text-ops-950">

    <div class="tactical-grid"></div>
    <div class="scan-overlay"></div>

    <div class="sticky top-0 z-50 bg-ops-950/90 backdrop-blur-md border-b border-ops-800 shadow-lg">
        <div class="h-1 w-full bg-gradient-to-r from-ops-900 via-ops-500 to-ops-900 opacity-50"></div>
        <div class="container mx-auto max-w-5xl px-4 py-3">
            <div class="flex flex-col sm:flex-row justify-between items-center gap-4">
                
                <div class="flex items-center gap-4 w-full sm:w-auto">
                    <div class="relative">
                        <div class="w-12 h-12 bg-ops-900 border border-ops-500 rounded flex items-center justify-center relative overflow-hidden group">
                            <i class="fa-solid fa-user-astronaut text-ops-400 text-xl group-hover:scale-110 transition-transform"></i>
                            <div class="absolute inset-0 border border-ops-500 opacity-50 animate-pulse-border"></div>
                        </div>
                        <div class="absolute -bottom-1 -right-1 bg-ops-950 border border-ops-500 text-[10px] px-1 text-ops-400 font-hud font-bold">ID: <?php echo $client_id; ?></div>
                    </div>
                    <div>
                        <div class="text-[10px] uppercase tracking-[0.2em] text-ops-400 font-hud">Operador Designado</div>
                        <div class="text-lg font-bold text-white font-hud tracking-wide"><?php echo htmlspecialchars($client['name']); ?></div>
                    </div>
                </div>

                <div class="flex items-center gap-6 w-full sm:w-auto justify-between sm:justify-end">
                    <div class="text-right">
                        <div class="text-[10px] uppercase text-ops-400 font-hud tracking-widest mb-0.5">Status da Missão</div>
                        <div class="font-hud font-bold text-xl rank-badge" id="rank-title">RECUTA</div>
                    </div>

                    <div class="relative w-40 h-10 bg-ops-900 border border-ops-800 skew-x-[-12deg] flex items-center px-1">
                        <div class="absolute top-0 left-0 text-[8px] text-ops-500 p-0.5 font-mono opacity-50">SYNC...</div>
                        <div class="h-6 w-full bg-ops-950 relative overflow-hidden">
                            <div id="xp-bar" class="h-full bg-gradient-to-r from-ops-800 to-ops-500 transition-all duration-1000 ease-out flex items-center justify-end pr-1" style="width: <?php echo $percentage; ?>%">
                                <div class="h-full w-[2px] bg-white opacity-50"></div>
                            </div>
                        </div>
                        <div class="absolute -right-2 -top-3 text-ops-400 font-bold font-hud text-sm skew-x-[12deg]">
                            <span id="header-pct"><?php echo $percentage; ?></span>%
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mx-auto max-w-4xl px-4 mt-12 mb-16 text-center">
        <div class="inline-block border border-ops-500/30 bg-ops-900/20 px-4 py-1 rounded-full mb-4">
            <span class="text-ops-400 text-xs font-hud tracking-[0.3em] uppercase animate-pulse">Sistema Online // Inicializando Protocolo</span>
        </div>
        <h1 class="text-4xl md:text-6xl font-bold text-white font-hud uppercase tracking-tight mb-4 text-glow">
            Painel de <span class="text-ops-500">Operações</span>
        </h1>
        <p class="text-slate-400 max-w-xl mx-auto font-sans border-l-2 border-ops-500 pl-4 text-left md:text-center md:border-l-0 md:border-t-2 md:pt-4 md:border-ops-500/20">
            Bem-vindo ao centro de comando. Complete os objetivos táticos abaixo para avançar para a próxima fase do projeto. A falha não é uma opção.
        </p>
    </div>

    <div class="container mx-auto max-w-4xl px-4 relative">
        <div class="absolute left-4 md:left-1/2 top-0 bottom-0 w-px bg-gradient-to-b from-transparent via-ops-800 to-transparent"></div>

        <?php 
        $week_count = 0;
        $total_weeks = count($weeks_data);
        
        foreach ($weeks_data as $week_num => $week): 
            $week_count++;
        ?>
        
        <div class="relative mb-16">
            
            <div class="flex md:justify-center items-center mb-8 pl-12 md:pl-0 relative">
                <div class="absolute left-0 md:left-1/2 md:-translate-x-1/2 w-8 h-8 bg-ops-950 border-2 border-ops-500 rotate-45 flex items-center justify-center z-10 shadow-[0_0_15px_rgba(16,185,129,0.4)]">
                    <div class="-rotate-45 text-ops-400 font-bold font-hud text-sm"><?php echo $week_num; ?></div>
                </div>
                <div class="md:absolute md:right-[55%] md:text-right text-left ml-4 md:ml-0">
                    <h2 class="text-2xl font-bold text-white font-hud uppercase tracking-wider"><?php echo htmlspecialchars($week['title']); ?></h2>
                </div>
            </div>

            <div class="space-y-6 pl-12 md:pl-0">
                <?php foreach ($week['topics'] as $topic_title => $tasks): ?>
                    
                    <div class="flex items-center gap-4 md:justify-center mb-4 opacity-70">
                        <div class="h-px bg-ops-800 flex-1 hidden md:block"></div>
                        <h3 class="font-hud font-bold text-ops-400 text-sm uppercase tracking-[0.2em] flex items-center gap-2">
                            <i class="fa-solid fa-microchip"></i> <?php echo htmlspecialchars($topic_title); ?>
                        </h3>
                        <div class="h-px bg-ops-800 flex-1"></div>
                    </div>

                    <div class="grid grid-cols-1 gap-4">
                        <?php foreach ($tasks as $task): 
                            $is_client = ($task['responsible'] === 'client');
                            $is_done = !empty($task['completed_at']);
                            $card_id = 'task-card-' . $task['id'];
                        ?>
                        
                        <div id="<?php echo $card_id; ?>" class="card-mission cut-corner p-1 transition-all duration-500 group <?php echo $is_done ? 'opacity-60 grayscale-[0.5] hover:grayscale-0' : 'hover:translate-x-1 hover:shadow-[0_0_20px_rgba(6,78,59,0.5)]'; ?>">
                            <div class="bg-ops-950/50 p-5 h-full relative">
                                
                                <div class="absolute top-2 right-2 w-2 h-2 border-t border-r border-ops-500"></div>
                                <div class="absolute bottom-2 left-2 w-2 h-2 border-b border-l border-ops-500"></div>

                                <div class="flex flex-col md:flex-row gap-4 justify-between items-start md:items-center">
                                    
                                    <div class="flex-1">
                                        <div class="flex items-center gap-3 mb-2">
                                            <i class="fa-solid <?php echo $is_done ? 'fa-shield-check text-ops-500' : 'fa-shield-halved text-ops-800'; ?> text-lg" id="icon-<?php echo $task['id']; ?>"></i>
                                            <h4 class="font-hud font-bold text-lg text-white uppercase tracking-wide <?php echo $is_done ? 'line-through text-slate-500' : ''; ?>" id="title-<?php echo $task['id']; ?>">
                                                <?php echo htmlspecialchars($task['name']); ?>
                                            </h4>
                                            
                                            <?php if (!$is_client): ?>
                                                <span class="text-[9px] font-bold bg-slate-800 text-slate-400 px-2 py-0.5 rounded border border-slate-700">INTEL INTERNA</span>
                                            <?php elseif (!$is_done): ?>
                                                <span class="text-[9px] font-bold bg-yellow-500/10 text-yellow-500 px-2 py-0.5 border border-yellow-500/30 animate-pulse" id="badge-<?php echo $task['id']; ?>">AÇÃO NECESSÁRIA</span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <p class="text-slate-400 text-sm font-sans border-l-2 border-ops-800 pl-3 leading-relaxed">
                                            <?php echo htmlspecialchars($task['description']); ?>
                                        </p>

                                        <div id="completed-date-<?php echo $task['id']; ?>" class="<?php echo $is_done ? 'block' : 'hidden'; ?> mt-3 text-xs font-mono text-ops-500 flex items-center gap-2">
                                            <span>// OBJETIVO NEUTRALIZADO EM: <?php echo $is_done ? date('d/m H:i', strtotime($task['completed_at'])) : ''; ?></span>
                                        </div>
                                    </div>

                                    <div class="flex items-center gap-3 shrink-0 w-full md:w-auto pt-4 md:pt-0 border-t border-ops-800/50 md:border-0">
                                        <?php if (!empty($task['url'])): ?>
                                            <a href="<?php echo $task['url']; ?>" target="_blank" 
                                               class="flex-1 md:flex-none text-center px-4 py-2 text-xs font-bold text-ops-400 border border-ops-800 hover:bg-ops-800 hover:text-white transition-colors uppercase tracking-wider">
                                                <i class="fa-solid fa-link mr-1"></i> Link
                                            </a>
                                        <?php endif; ?>

                                        <?php if ($is_client): ?>
                                            <button onclick="markDone(this, <?php echo $task['id']; ?>)"
                                                    id="btn-<?php echo $task['id']; ?>"
                                                    class="<?php echo $is_done ? 'hidden' : 'flex'; ?> btn-tactical flex-1 md:flex-none justify-center items-center gap-2 px-6 py-2 font-hud font-bold text-white text-sm tracking-wider shadow-lg">
                                                <span>EXECUTAR</span>
                                                <i class="fa-solid fa-crosshairs"></i>
                                            </button>
                                            
                                            <div id="done-visual-<?php echo $task['id']; ?>" class="<?php echo $is_done ? 'flex' : 'hidden'; ?> items-center justify-center w-10 h-10 rounded bg-ops-900 border border-ops-500 text-ops-500 shadow-[0_0_10px_rgba(16,185,129,0.2)]">
                                                <i class="fa-solid fa-check"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <?php endforeach; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <div id="completion-overlay" class="fixed inset-0 z-[100] hidden flex items-center justify-center">
        <div class="absolute inset-0 bg-black/90 backdrop-blur-sm" onclick="closeOverlay()">
            <div class="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/dark-matter.png')] opacity-50"></div>
        </div>
        
        <div class="relative z-10 bg-ops-950 border-2 border-ops-500 p-1 max-w-lg w-full mx-4 transform scale-95 opacity-0 transition-all duration-500" id="modal-card">
            <div class="border border-ops-500/30 bg-ops-900/30 p-8 text-center relative overflow-hidden">
                <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-64 h-64 border border-dashed border-ops-500/20 rounded-full animate-spin-slow duration-[10s]"></div>

                <div class="mb-6 relative">
                    <i class="fa-solid fa-medal text-6xl text-yellow-500 drop-shadow-[0_0_15px_rgba(234,179,8,0.6)] animate-bounce"></i>
                </div>
                
                <h2 class="text-4xl font-bold text-white font-hud mb-2 tracking-widest">MISSÃO CUMPRIDA</h2>
                <div class="h-0.5 w-24 bg-ops-500 mx-auto mb-6"></div>
                
                <p class="text-slate-400 mb-8 font-sans">
                    Todos os objetivos operacionais foram alcançados. A equipe HQ foi notificada e o procedimento de decolagem foi autorizado.
                </p>
                
                <button onclick="closeOverlay()" class="w-full py-4 bg-ops-500 hover:bg-ops-400 text-ops-950 font-bold font-hud uppercase tracking-[0.2em] transition-all">
                    Retornar à Base
                </button>
            </div>
        </div>
    </div>



    <script>
        const CLIENT_ID = <?php echo $client_id; ?>;
        const CLIENT_SLUG = "<?php echo $client_slug; ?>";
        let totalTasks = <?php echo $total_client_tasks; ?>;
        let doneTasks = <?php echo $total_client_completed; ?>;

        // Sistema de Ranks
        const RANKS = [
            { pct: 0, title: 'RECRUTA' },
            { pct: 25, title: 'AGENTE' },
            { pct: 50, title: 'GUERRA' },
            { pct: 75, title: 'PRAÇA' },
            { pct: 100, title: 'LENDA' }
        ];

        function updateRank(pct) {
            let currentTitle = 'RECRUTA';
            for (let r of RANKS) {
                if (pct >= r.pct) currentTitle = r.title;
            }
            const el = document.getElementById('rank-title');
            
            // Efeito Glitch no texto
            let original = currentTitle;
            let iterations = 0;
            const interval = setInterval(() => {
                el.innerText = el.innerText.split("").map((letter, index) => {
                    if(index < iterations) return original[index];
                    return "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"[Math.floor(Math.random() * 36)];
                }).join("");
                
                if(iterations >= original.length) clearInterval(interval);
                iterations += 1/3;
            }, 30);
        }

        // Inicializa Rank
        updateRank(<?php echo $percentage; ?>);

        async function markDone(btn, taskId) {
            const originalContent = btn.innerHTML;
            
            btn.disabled = true;
            btn.innerHTML = '<i class="fa-solid fa-circle-notch fa-spin"></i> SALVANDO...';
            btn.classList.add('opacity-75', 'cursor-wait');

            try {
                const res = await fetch(`index.php?client=${CLIENT_SLUG}`, {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({ client_id: CLIENT_ID, task_id: taskId })
                });
                const data = await res.json();

                if (data.success) {
                    // 1. Confete (Verde e Dourado)
                    const rect = btn.getBoundingClientRect();
                    confetti({
                        particleCount: 50,
                        spread: 60,
                        origin: { x: (rect.left + rect.width/2)/window.innerWidth, y: (rect.top + rect.height/2)/window.innerHeight },
                        colors: ['#10b981', '#064e3b', '#fbbf24'],
                        shapes: ['square'], // Quadrados combinam mais com o tema
                        ticks: 200
                    });

                    // 2. Atualização Visual Tática
                    const card = document.getElementById(`task-card-${taskId}`);
                    const title = document.getElementById(`title-${taskId}`);
                    const badge = document.getElementById(`badge-${taskId}`);
                    const icon = document.getElementById(`icon-${taskId}`);
                    const doneVisual = document.getElementById(`done-visual-${taskId}`);
                    const dateText = document.getElementById(`completed-date-${taskId}`);

                    // Escurece o card
                    card.classList.add('opacity-60', 'grayscale-[0.5]');
                    
                    // Risca título
                    title.classList.add('line-through', 'text-slate-500');
                    
                    // Troca ícone do escudo
                    icon.className = 'fa-solid fa-shield-check text-ops-500 text-lg';
                    
                    if(badge) badge.remove();
                    btn.remove();
                    
                    doneVisual.classList.remove('hidden');
                    doneVisual.classList.add('flex');

                    dateText.innerHTML = `<span>// OBJETIVO NEUTRALIZADO EM: ${data.completed_at}</span>`;
                    dateText.classList.remove('hidden');

                    // 3. Progresso & Rank
                    doneTasks++;
                    updateProgress();
                    showToast(`Objetivo ${data.completed_at} confirmado. Bom trabalho, Agente.`, true);

                } else {
                    showToast(data.message || 'Falha na comunicação.', false);
                    resetButton(btn, originalContent);
                }
            } catch (e) {
                console.error(e);
                showToast('Erro Crítico: Sem conexão.', false);
                resetButton(btn, originalContent);
            }
        }

        function resetButton(btn, html) {
            btn.innerHTML = html;
            btn.disabled = false;
            btn.classList.remove('opacity-75', 'cursor-wait');
        }

        function updateProgress() {
            const pct = totalTasks > 0 ? Math.round((doneTasks / totalTasks) * 100) : 0;
            
            document.getElementById('xp-bar').style.width = pct + '%';
            document.getElementById('header-pct').innerText = pct;
            
            updateRank(pct);

            if (pct === 100) {
                setTimeout(openOverlay, 1200);
            }
        }

        function openOverlay() {
            const overlay = document.getElementById('completion-overlay');
            const card = document.getElementById('modal-card');
            overlay.classList.remove('hidden');
            
            setTimeout(() => {
                card.classList.remove('scale-95', 'opacity-0');
                card.classList.add('scale-100', 'opacity-100');
            }, 50);

            // Confete Final Explosivo
            const duration = 3000;
            const end = Date.now() + duration;
            (function frame() {
                confetti({ particleCount: 4, angle: 60, spread: 55, origin: { x: 0 }, colors: ['#10b981', '#fbbf24'] });
                confetti({ particleCount: 4, angle: 120, spread: 55, origin: { x: 1 }, colors: ['#10b981', '#fbbf24'] });
                if (Date.now() < end) requestAnimationFrame(frame);
            }());
        }

        function closeOverlay() {
            document.getElementById('completion-overlay').classList.add('hidden');
        }

        function showToast(msg, success) {
            const t = document.getElementById('toast');
            const m = document.getElementById('toast-msg');
            
            m.innerText = msg;
            t.classList.remove('translate-x-full');
            
            if(success) {
                t.style.borderColor = '#10b981';
            } else {
                t.style.borderColor = '#ef4444';
            }

            setTimeout(() => {
                t.classList.add('translate-x-full');
            }, 4000);
        }
    </script>
</body>
</html>