<?php
// -------------------------------------------------
// ARQUIVO DE CONFIGURAÇÃO & BACKEND (INTACTO)
// -------------------------------------------------
define('DB_HOST', 'localhost');
define('DB_USER', 'smaisdigital_user_onboarding'); 
define('DB_PASS', 'Admin@99@SMAIS'); 
define('DB_NAME', 'smaisdigital_onboarding'); 
define('N8N_WEBHOOK_URL', 'https://seu-dominio-n8n.com/webhook/ID-DO-WEBHOOK');

date_default_timezone_set('America/Sao_Paulo');
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) { die("Conexão falhou: " . $conn->connect_error); }
$conn->set_charset("utf8mb4");

// -------------------------------------------------
// API - MARCAR COMO FEITO
// -------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    $input = json_decode(file_get_contents('php://input'), true);
    $client_id = $input['client_id'] ?? 0;
    $task_id = $input['task_id'] ?? 0;

    if ($client_id > 0 && $task_id > 0) {
        $stmt_verify = $conn->prepare("SELECT responsible FROM tasks WHERE id = ?");
        $stmt_verify->bind_param("i", $task_id);
        $stmt_verify->execute();
        $res_verify = $stmt_verify->get_result();
        $task_info = $res_verify->fetch_assoc();

        if ($task_info && $task_info['responsible'] === 'client') {
            $check = $conn->prepare("SELECT id FROM client_task_progress WHERE client_id = ? AND task_id = ?");
            $check->bind_param("ii", $client_id, $task_id);
            $check->execute();
            
            if ($check->get_result()->num_rows == 0) {
                $now = date('Y-m-d H:i:s');
                $ins = $conn->prepare("INSERT INTO client_task_progress (client_id, task_id, completed_at) VALUES (?, ?, ?)");
                $ins->bind_param("iis", $client_id, $task_id, $now);
                
                if ($ins->execute()) {
                    // Webhook silencioso
                    $c_name = $conn->query("SELECT name FROM clients WHERE id = $client_id")->fetch_object()->name;
                    $t_name = $conn->query("SELECT name FROM tasks WHERE id = $task_id")->fetch_object()->name;
                    $ctx = stream_context_create(['http' => ['method'=>'POST', 'header'=>"Content-Type: application/json\r\n", 'content'=>json_encode(['client'=>$c_name, 'task'=>$t_name, 'date'=>$now]), 'ignore_errors'=>true]]);
                    @file_get_contents(N8N_WEBHOOK_URL, false, $ctx);

                    echo json_encode(['success' => true, 'completed_at' => date('d/m/Y H:i', strtotime($now))]);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Erro SQL']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'Já concluída']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Ação restrita']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    }
    exit;
}

// -------------------------------------------------
// RENDERIZAÇÃO DA PÁGINA
// -------------------------------------------------
$client_slug = $_GET['client'] ?? '';
if (empty($client_slug)) die("Cliente não informado na URL.");

$stmt = $conn->prepare("SELECT id, name FROM clients WHERE client_slug = ?");
$stmt->bind_param("s", $client_slug);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows == 0) die("Cliente não encontrado.");
$client = $res->fetch_assoc();
$client_id = $client['id'];

// Buscar tarefas e progresso
$sql = "
    SELECT t.*, p.completed_at 
    FROM tasks t 
    LEFT JOIN client_task_progress p ON t.id = p.task_id AND p.client_id = $client_id
    ORDER BY t.week ASC, t.order_index ASC
";
$query_tasks = $conn->query($sql);

$weeks_data = [];
$total_client_tasks = 0;
$total_client_completed = 0;

while ($row = $query_tasks->fetch_assoc()) {
    $wk = $row['week'];
    $topic = $row['topic']; 
    
    if (!isset($weeks_data[$wk])) {
        $weeks_data[$wk] = [
            'title' => $row['week_title'],
            'topics' => []
        ];
    }
    
    if (!isset($weeks_data[$wk]['topics'][$topic])) {
        $weeks_data[$wk]['topics'][$topic] = [];
    }

    if ($row['responsible'] === 'client') {
        $total_client_tasks++;
        if ($row['completed_at']) $total_client_completed++;
    }

    $weeks_data[$wk]['topics'][$topic][] = $row;
}

$percentage = ($total_client_tasks > 0) ? round(($total_client_completed / $total_client_tasks) * 100) : 0;
?>

<!DOCTYPE html>
<html lang="pt-BR" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Onboarding Mission | <?php echo htmlspecialchars($client['name']); ?></title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700;900&family=Space+Grotesk:wght@700&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Outfit', 'sans-serif'],
                        display: ['Space Grotesk', 'sans-serif'],
                    },
                    colors: {
                        dark: {
                            900: '#0f172a',
                            800: '#1e293b',
                            700: '#334155',
                        },
                        neon: {
                            green: '#00ff9d',
                            purple: '#bd00ff',
                            blue: '#00f3ff'
                        }
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'pulse-slow': 'pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                        'glow': 'glow 2s ease-in-out infinite alternate',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': { transform: 'translateY(0)' },
                            '50%': { transform: 'translateY(-10px)' },
                        },
                        glow: {
                            'from': { boxShadow: '0 0 10px -10px #00ff9d' },
                            'to': { boxShadow: '0 0 20px 5px rgba(0, 255, 157, 0.2)' }
                        }
                    }
                }
            }
        }
    </script>

    <style>
        /* Custom Scrollbar */
        ::-webkit-scrollbar { width: 8px; }
        ::-webkit-scrollbar-track { background: #0f172a; }
        ::-webkit-scrollbar-thumb { background: #334155; border-radius: 4px; }
        ::-webkit-scrollbar-thumb:hover { background: #475569; }

        body {
            background-color: #0f172a;
            background-image: 
                radial-gradient(at 0% 0%, hsla(253,16%,7%,1) 0, transparent 50%), 
                radial-gradient(at 50% 0%, hsla(225,39%,30%,1) 0, transparent 50%), 
                radial-gradient(at 100% 0%, hsla(339,49%,30%,1) 0, transparent 50%);
            background-attachment: fixed;
            color: #e2e8f0;
        }

        .glass-panel {
            background: rgba(30, 41, 59, 0.4);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.05);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
        }

        .glass-header {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(16px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        }

        .neon-text {
            text-shadow: 0 0 10px rgba(0, 255, 157, 0.5);
        }

        .task-card-done {
            background: linear-gradient(145deg, rgba(6, 78, 59, 0.4) 0%, rgba(6, 95, 70, 0.1) 100%);
            border: 1px solid rgba(34, 197, 94, 0.3);
        }

        .btn-dopamine {
            background: linear-gradient(90deg, #10b981 0%, #059669 100%);
            position: relative;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .btn-dopamine:hover {
            transform: translateY(-2px);
            box-shadow: 0 0 20px rgba(16, 185, 129, 0.4);
        }
        .btn-dopamine:active { transform: scale(0.95); }
        
        .timeline-line {
            background: linear-gradient(to bottom, #334155 0%, #10b981 50%, #334155 100%);
            opacity: 0.3;
        }
    </style>
</head>
<body class="antialiased min-h-screen pb-32">

    <div class="sticky top-0 z-50 glass-header shadow-lg transition-all duration-300" id="main-header">
        <div class="container mx-auto max-w-4xl px-4 py-3">
            <div class="flex justify-between items-center">
                <div class="flex items-center gap-4">
                    <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-emerald-400 to-cyan-500 flex items-center justify-center shadow-lg shadow-emerald-500/20">
                        <i class="fa-solid fa-rocket text-white text-lg"></i>
                    </div>
                    <div>
                        <div class="text-[10px] uppercase tracking-[0.2em] text-slate-400 font-bold">Cliente</div>
                        <div class="text-sm font-bold text-white font-display tracking-wide"><?php echo htmlspecialchars($client['name']); ?></div>
                    </div>
                </div>

                <div class="flex items-center gap-4">
                    <div class="text-right hidden sm:block">
                        <div class="text-[10px] uppercase tracking-widest text-slate-400 font-bold">Progresso da Missão</div>
                        <div class="text-emerald-400 font-bold font-display" id="header-pct"><?php echo $percentage; ?>% Completo</div>
                    </div>
                    <div class="relative w-32 h-3 bg-slate-700/50 rounded-full overflow-hidden backdrop-blur-sm border border-white/5">
                        <div id="xp-bar" class="absolute top-0 left-0 h-full bg-gradient-to-r from-emerald-500 via-teal-400 to-cyan-400 shadow-[0_0_10px_rgba(16,185,129,0.5)] transition-all duration-1000 ease-out" style="width: <?php echo $percentage; ?>%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mx-auto max-w-4xl px-4 mt-12 mb-16 text-center relative">
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-64 h-64 bg-emerald-500/20 rounded-full blur-3xl -z-10 animate-pulse-slow"></div>
        
        <h1 class="text-4xl md:text-6xl font-black text-white font-display mb-4 tracking-tight">
            Sua Jornada <span class="text-transparent bg-clip-text bg-gradient-to-r from-emerald-400 to-cyan-400 animate-pulse">Começa Aqui</span>
        </h1>
        <p class="text-slate-400 text-lg max-w-xl mx-auto leading-relaxed">
            Complete as missões abaixo para desbloquear todo o potencial do seu projeto. Cada check é um passo para o sucesso.
        </p>
    </div>

    <div class="container mx-auto max-w-3xl px-4 relative">
        
        <?php 
        $week_count = 0;
        $total_weeks = count($weeks_data);
        
        foreach ($weeks_data as $week_num => $week): 
            $week_count++;
            $is_last_week = ($week_count === $total_weeks);
        ?>
        
        <div class="relative pl-8 md:pl-12 pb-16 group">
            
            <?php if (!$is_last_week): ?>
            <div class="absolute left-[19px] md:left-[23px] top-12 bottom-0 w-[2px] bg-slate-700/50 group-hover:bg-emerald-500/30 transition-colors duration-500"></div>
            <?php endif; ?>

            <div class="absolute left-0 md:left-1 top-0 flex flex-col items-center z-10">
                <div class="w-10 h-10 md:w-12 md:h-12 rounded-full bg-slate-800 border-2 border-slate-600 group-hover:border-emerald-500 group-hover:shadow-[0_0_15px_rgba(16,185,129,0.4)] transition-all duration-300 flex items-center justify-center text-slate-300 group-hover:text-emerald-400 font-display font-bold text-lg">
                    <?php echo $week_num; ?>
                </div>
            </div>

            <div class="animate-float" style="animation-duration: <?php echo rand(5,8); ?>s; animation-delay: <?php echo rand(0,2); ?>s">
                <h2 class="text-2xl font-bold text-white mb-1 font-display flex items-center gap-3">
                    <?php echo htmlspecialchars($week['title']); ?>
                </h2>
                <div class="h-1 w-20 bg-gradient-to-r from-emerald-500 to-transparent rounded-full mb-8 opacity-50"></div>
            </div>

            <div class="space-y-8">
                <?php foreach ($week['topics'] as $topic_title => $tasks): ?>
                    
                    <div class="glass-panel rounded-2xl p-1 overflow-hidden transition-all hover:border-white/10">
                        <div class="bg-slate-800/50 px-5 py-3 flex items-center gap-3 border-b border-white/5">
                            <i class="fa-solid fa-layer-group text-emerald-400 text-xs"></i>
                            <h3 class="font-bold text-slate-300 text-sm uppercase tracking-widest">
                                <?php echo htmlspecialchars($topic_title); ?>
                            </h3>
                        </div>

                        <div class="divide-y divide-white/5 bg-slate-900/30">
                            <?php foreach ($tasks as $task): 
                                $is_client = ($task['responsible'] === 'client');
                                $is_done = !empty($task['completed_at']);
                                $card_id = 'task-card-' . $task['id'];
                            ?>
                            
                            <div id="<?php echo $card_id; ?>" class="p-5 md:p-6 transition-all duration-500 <?php echo $is_done ? 'task-card-done' : 'hover:bg-white/5'; ?> group/task relative">
                                
                                <?php if(!$is_done): ?>
                                <div class="absolute inset-0 bg-gradient-to-r from-emerald-500/0 via-emerald-500/5 to-emerald-500/0 translate-x-[-100%] group-hover/task:translate-x-[100%] transition-transform duration-1000 pointer-events-none"></div>
                                <?php endif; ?>

                                <div class="flex flex-col md:flex-row gap-5 md:items-center justify-between relative z-10">
                                    
                                    <div class="flex-1 space-y-2">
                                        <div class="flex items-center gap-3">
                                            <h4 class="font-semibold text-lg <?php echo $is_done ? 'text-emerald-400 line-through opacity-70' : 'text-white'; ?> transition-colors duration-300 font-display" id="title-<?php echo $task['id']; ?>">
                                                <?php echo htmlspecialchars($task['name']); ?>
                                            </h4>
                                            
                                            <?php if (!$is_client): ?>
                                                <span class="px-2 py-0.5 rounded text-[10px] font-bold bg-slate-700 text-slate-400 border border-slate-600">INTERNO</span>
                                            <?php elseif (!$is_done): ?>
                                                <span class="px-2 py-0.5 rounded text-[10px] font-bold bg-amber-500/20 text-amber-400 border border-amber-500/30 animate-pulse" id="badge-<?php echo $task['id']; ?>">SUA VEZ</span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <p class="text-slate-400 text-sm leading-relaxed font-light max-w-2xl">
                                            <?php echo htmlspecialchars($task['description']); ?>
                                        </p>

                                        <div id="completed-date-<?php echo $task['id']; ?>" class="<?php echo $is_done ? 'block' : 'hidden'; ?> text-xs text-emerald-500 font-mono flex items-center gap-2 mt-2">
                                            <i class="fa-solid fa-check-circle"></i>
                                            <span>Concluído em <?php echo $is_done ? date('d/m/Y', strtotime($task['completed_at'])) : ''; ?></span>
                                        </div>
                                    </div>

                                    <div class="flex items-center gap-3 shrink-0 self-start md:self-center">
                                        <?php if (!empty($task['url'])): ?>
                                            <a href="<?php echo $task['url']; ?>" target="_blank" 
                                               class="px-4 py-2 rounded-lg text-xs font-bold text-slate-300 bg-slate-800 border border-slate-600 hover:bg-slate-700 hover:text-white hover:border-slate-500 transition-all flex items-center gap-2 group/btn">
                                                <span>ACESSAR</span>
                                                <i class="fa-solid fa-arrow-up-right-from-square text-slate-500 group-hover/btn:text-white transition-colors"></i>
                                            </a>
                                        <?php endif; ?>

                                        <?php if ($is_client): ?>
                                            <button onclick="markDone(this, <?php echo $task['id']; ?>)"
                                                    id="btn-<?php echo $task['id']; ?>"
                                                    class="<?php echo $is_done ? 'hidden' : 'flex'; ?> btn-dopamine items-center gap-2 px-5 py-2.5 rounded-lg text-white font-bold shadow-lg font-display text-xs tracking-wide uppercase">
                                                <i class="fa-regular fa-square-check"></i>
                                                <span>Marcar Feito</span>
                                            </button>
                                            
                                            <div id="done-icon-<?php echo $task['id']; ?>" class="<?php echo $is_done ? 'flex' : 'hidden'; ?> items-center justify-center w-10 h-10 rounded-full bg-emerald-500/20 text-emerald-400 border border-emerald-500/50 shadow-[0_0_15px_rgba(16,185,129,0.3)]">
                                                <i class="fa-solid fa-check text-lg"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <div id="completion-overlay" class="fixed inset-0 z-[100] hidden flex items-center justify-center">
        <div class="absolute inset-0 bg-slate-900/90 backdrop-blur-sm" onclick="closeOverlay()"></div>
        
        <div class="relative z-10 bg-slate-800 border border-white/10 p-8 rounded-3xl max-w-md w-full text-center shadow-2xl transform scale-90 opacity-0 transition-all duration-500" id="modal-card">
            <div class="w-24 h-24 mx-auto bg-gradient-to-br from-yellow-400 to-orange-500 rounded-full flex items-center justify-center mb-6 shadow-[0_0_30px_rgba(251,191,36,0.6)] animate-bounce">
                <i class="fa-solid fa-trophy text-4xl text-white drop-shadow-md"></i>
            </div>
            
            <h2 class="text-3xl font-black text-white font-display mb-2">MISSÃO CUMPRIDA!</h2>
            <p class="text-slate-400 mb-8 leading-relaxed">
                Parabéns! Você concluiu todas as etapas do seu onboarding. Nossa equipe já recebeu o sinal e estamos prontos para decolar! 🚀
            </p>
            
            <button onclick="closeOverlay()" class="w-full py-4 bg-gradient-to-r from-emerald-500 to-teal-500 hover:from-emerald-400 hover:to-teal-400 text-white font-bold rounded-xl shadow-lg shadow-emerald-500/30 transition-all transform hover:scale-[1.02]">
                VOLTAR AO DASHBOARD
            </button>
        </div>
    </div>

    <div id="toast" class="fixed bottom-8 left-1/2 -translate-x-1/2 flex items-center gap-3 px-6 py-3 rounded-xl bg-slate-800 border border-white/10 shadow-2xl text-sm font-medium text-white transform translate-y-20 opacity-0 transition-all duration-300 z-[90]">
        <div id="toast-icon"></div>
        <span id="toast-msg"></span>
    </div>

    <script>
        const CLIENT_ID = <?php echo $client_id; ?>;
        const CLIENT_SLUG = "<?php echo $client_slug; ?>";
        let totalTasks = <?php echo $total_client_tasks; ?>;
        let doneTasks = <?php echo $total_client_completed; ?>;

        // Sons para Dopamina (Opcional - sutil e satisfatório)
        const successSound = new Audio('data:audio/wav;base64,UklGRl9vT19XQVZFZm10IBAAAAABAAEAQB8AAEAfAAABAAgAZGF0YU...'); // (Placeholder, usar visual é mais seguro)

        async function markDone(btn, taskId) {
            const originalContent = btn.innerHTML;
            
            // Estado de Loading no Botão
            btn.disabled = true;
            btn.innerHTML = '<i class="fa-solid fa-circle-notch fa-spin"></i> Processando...';
            btn.classList.add('opacity-75', 'cursor-not-allowed');

            try {
                const res = await fetch(`index.php?client=${CLIENT_SLUG}`, {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({ client_id: CLIENT_ID, task_id: taskId })
                });
                const data = await res.json();

                if (data.success) {
                    // 1. Explosão de Confetti no local do clique
                    const rect = btn.getBoundingClientRect();
                    const x = (rect.left + rect.width / 2) / window.innerWidth;
                    const y = (rect.top + rect.height / 2) / window.innerHeight;
                    
                    confetti({
                        particleCount: 60,
                        spread: 70,
                        origin: { x: x, y: y },
                        colors: ['#10b981', '#34d399', '#ffffff'],
                        disableForReducedMotion: true,
                        zIndex: 9999
                    });

                    // 2. Transformação Visual do Card (Dopamina Visual)
                    const card = document.getElementById(`task-card-${taskId}`);
                    const title = document.getElementById(`title-${taskId}`);
                    const badge = document.getElementById(`badge-${taskId}`);
                    const doneIcon = document.getElementById(`done-icon-${taskId}`);
                    const dateText = document.getElementById(`completed-date-${taskId}`);

                    // Aplica estilo de concluído
                    card.classList.remove('hover:bg-white/5');
                    card.classList.add('task-card-done', 'scale-[1.01]', 'shadow-lg', 'shadow-emerald-900/20');
                    setTimeout(() => card.classList.remove('scale-[1.01]'), 300); // Efeito de pulso rápido

                    // Texto
                    title.classList.remove('text-white');
                    title.classList.add('text-emerald-400', 'line-through', 'opacity-70');

                    // Remove Badge "Sua Vez"
                    if(badge) badge.remove();

                    // Troca Botão por Ícone
                    btn.remove();
                    doneIcon.classList.remove('hidden');
                    doneIcon.classList.add('flex', 'animate-bounce');
                    setTimeout(() => doneIcon.classList.remove('animate-bounce'), 1000);

                    // Mostra Data
                    dateText.innerHTML = `<i class="fa-solid fa-check-circle"></i> <span>Concluído em ${data.completed_at}</span>`;
                    dateText.classList.remove('hidden');

                    // 3. Atualiza Barra de Progresso Global
                    doneTasks++;
                    updateProgress();

                    showToast('Tarefa concluída com sucesso!', 'success');

                } else {
                    showToast(data.message || 'Erro ao salvar', 'error');
                    resetButton(btn, originalContent);
                }
            } catch (e) {
                console.error(e);
                showToast('Erro de conexão com o servidor.', 'error');
                resetButton(btn, originalContent);
            }
        }

        function resetButton(btn, html) {
            btn.innerHTML = html;
            btn.disabled = false;
            btn.classList.remove('opacity-75', 'cursor-not-allowed');
        }

        function updateProgress() {
            const pct = totalTasks > 0 ? Math.round((doneTasks / totalTasks) * 100) : 0;
            const bar = document.getElementById('xp-bar');
            const txt = document.getElementById('header-pct');
            
            // Animação da Barra
            bar.style.width = pct + '%';
            txt.innerText = pct + '% Completo';
            
            // Flash na barra
            bar.classList.add('brightness-150');
            setTimeout(() => bar.classList.remove('brightness-150'), 500);

            if (pct === 100) {
                setTimeout(openOverlay, 800);
            }
        }

        function openOverlay() {
            const overlay = document.getElementById('completion-overlay');
            const card = document.getElementById('modal-card');
            overlay.classList.remove('hidden');
            
            // Animação de entrada
            setTimeout(() => {
                card.classList.remove('scale-90', 'opacity-0');
                card.classList.add('scale-100', 'opacity-100');
            }, 10);

            // Super Chuva de Confetes
            const duration = 3000;
            const end = Date.now() + duration;

            (function frame() {
                confetti({
                    particleCount: 5,
                    angle: 60,
                    spread: 55,
                    origin: { x: 0 },
                    colors: ['#fbbf24', '#10b981', '#8b5cf6']
                });
                confetti({
                    particleCount: 5,
                    angle: 120,
                    spread: 55,
                    origin: { x: 1 },
                    colors: ['#fbbf24', '#10b981', '#8b5cf6']
                });

                if (Date.now() < end) {
                    requestAnimationFrame(frame);
                }
            }());
        }

        function closeOverlay() {
            const overlay = document.getElementById('completion-overlay');
            overlay.classList.add('hidden');
        }

        function showToast(msg, type) {
            const t = document.getElementById('toast');
            const m = document.getElementById('toast-msg');
            const i = document.getElementById('toast-icon');
            
            // Cores baseadas no tipo
            if (type === 'success') {
                i.innerHTML = '<i class="fa-solid fa-check-circle text-emerald-400 text-lg"></i>';
                t.className = "fixed bottom-8 left-1/2 -translate-x-1/2 flex items-center gap-3 px-6 py-3 rounded-xl bg-slate-800 border border-emerald-500/30 shadow-[0_0_20px_rgba(16,185,129,0.2)] text-sm font-medium text-white transition-all duration-300 z-[90]";
            } else {
                i.innerHTML = '<i class="fa-solid fa-circle-exclamation text-red-400 text-lg"></i>';
                t.className = "fixed bottom-8 left-1/2 -translate-x-1/2 flex items-center gap-3 px-6 py-3 rounded-xl bg-slate-800 border border-red-500/30 shadow-lg text-sm font-medium text-white transition-all duration-300 z-[90]";
            }

            m.innerText = msg;
            t.classList.remove('translate-y-20', 'opacity-0');
            
            setTimeout(() => {
                t.classList.add('translate-y-20', 'opacity-0');
            }, 3500);
        }
    </script>
</body>
</html>