<?php
// ARQUIVO DE CONFIGURAÇÃO
// -------------------------------------------------
define('DB_HOST', 'localhost');
define('DB_USER', 'smaisdigital_user_onboarding'); 
define('DB_PASS', 'Admin@99@SMAIS'); 
define('DB_NAME', 'smaisdigital_onboarding'); 
define('N8N_WEBHOOK_URL', 'https://seu-dominio-n8n.com/webhook/ID-DO-WEBHOOK');

date_default_timezone_set('America/Sao_Paulo');
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) { die("Conexão falhou: " . $conn->connect_error); }
$conn->set_charset("utf8mb4");

// -------------------------------------------------
// API - MARCAR COMO FEITO
// -------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    $input = json_decode(file_get_contents('php://input'), true);
    $client_id = $input['client_id'] ?? 0;
    $task_id = $input['task_id'] ?? 0;

    if ($client_id > 0 && $task_id > 0) {
        $stmt_verify = $conn->prepare("SELECT responsible FROM tasks WHERE id = ?");
        $stmt_verify->bind_param("i", $task_id);
        $stmt_verify->execute();
        $res_verify = $stmt_verify->get_result();
        $task_info = $res_verify->fetch_assoc();

        if ($task_info && $task_info['responsible'] === 'client') {
            $check = $conn->prepare("SELECT id FROM client_task_progress WHERE client_id = ? AND task_id = ?");
            $check->bind_param("ii", $client_id, $task_id);
            $check->execute();
            
            if ($check->get_result()->num_rows == 0) {
                $now = date('Y-m-d H:i:s');
                $ins = $conn->prepare("INSERT INTO client_task_progress (client_id, task_id, completed_at) VALUES (?, ?, ?)");
                $ins->bind_param("iis", $client_id, $task_id, $now);
                
                if ($ins->execute()) {
                    // Webhook silencioso
                    $c_name = $conn->query("SELECT name FROM clients WHERE id = $client_id")->fetch_object()->name;
                    $t_name = $conn->query("SELECT name FROM tasks WHERE id = $task_id")->fetch_object()->name;
                    $ctx = stream_context_create(['http' => ['method'=>'POST', 'header'=>"Content-Type: application/json\r\n", 'content'=>json_encode(['client'=>$c_name, 'task'=>$t_name, 'date'=>$now]), 'ignore_errors'=>true]]);
                    @file_get_contents(N8N_WEBHOOK_URL, false, $ctx);

                    echo json_encode(['success' => true, 'completed_at' => date('d/m/Y H:i', strtotime($now))]);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Erro SQL']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'Já concluída']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Ação restrita']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    }
    exit;
}

// -------------------------------------------------
// RENDERIZAÇÃO DA PÁGINA
// -------------------------------------------------
$client_slug = $_GET['client'] ?? '';
if (empty($client_slug)) die("Cliente não informado na URL.");

$stmt = $conn->prepare("SELECT id, name FROM clients WHERE client_slug = ?");
$stmt->bind_param("s", $client_slug);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows == 0) die("Cliente não encontrado.");
$client = $res->fetch_assoc();
$client_id = $client['id'];

// Buscar tarefas e progresso
$sql = "
    SELECT t.*, p.completed_at 
    FROM tasks t 
    LEFT JOIN client_task_progress p ON t.id = p.task_id AND p.client_id = $client_id
    ORDER BY t.week ASC, t.order_index ASC
";
$query_tasks = $conn->query($sql);

$weeks_data = [];
$total_client_tasks = 0;
$total_client_completed = 0;

while ($row = $query_tasks->fetch_assoc()) {
    $wk = $row['week'];
    $topic = $row['topic']; // Agora agrupamos também por tópico
    
    if (!isset($weeks_data[$wk])) {
        $weeks_data[$wk] = [
            'title' => $row['week_title'],
            'topics' => []
        ];
    }
    
    if (!isset($weeks_data[$wk]['topics'][$topic])) {
        $weeks_data[$wk]['topics'][$topic] = [];
    }

    if ($row['responsible'] === 'client') {
        $total_client_tasks++;
        if ($row['completed_at']) $total_client_completed++;
    }

    $weeks_data[$wk]['topics'][$topic][] = $row;
}

$percentage = ($total_client_tasks > 0) ? round(($total_client_completed / $total_client_tasks) * 100) : 0;
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Onboarding - <?php echo htmlspecialchars($client['name']); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f0fdf4; }
        
        /* Smooth Scrolling */
        html { scroll-behavior: smooth; }

        .task-card { transition: all 0.2s ease-in-out; }
        .task-card:hover { transform: translateY(-1px); }
        
        .btn-action { transition: all 0.2s; }
        .btn-action:active { transform: scale(0.98); }

        /* Efeitos */
        @keyframes slideUp { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
        .animate-up { animation: slideUp 0.5s ease-out forwards; opacity: 0; }

        .completed-card { 
            background-color: #f0fdf4; 
            border-color: #bbf7d0; 
        }
        
        /* Linha da Timeline */
        .timeline-connector {
            position: absolute; left: 19px; top: 40px; bottom: -20px; width: 2px; background: #dcfce7; z-index: 0;
        }
        .last-item .timeline-connector { display: none; }

    </style>
</head>
<body class="bg-[#f0fdf4] text-gray-800 pb-24">

    <!-- Header Sticky -->
    <div class="sticky top-0 z-50 bg-white/95 backdrop-blur border-b border-green-100 shadow-sm">
        <div class="container mx-auto max-w-3xl px-4 py-3 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <!-- Logo -->
                <img src="logo-smais.png" class="h-8 w-auto" onerror="this.style.display='none';">
                <div class="leading-tight hidden sm:block">
                    <div class="text-[10px] font-bold text-gray-400 tracking-widest uppercase">Onboarding</div>
                    <div class="text-sm font-bold text-gray-900"><?php echo htmlspecialchars($client['name']); ?></div>
                </div>
            </div>
            
            <!-- Barra de Progresso Compacta -->
            <div class="flex items-center gap-3">
                <span id="progress-text" class="text-sm font-bold text-green-800"><?php echo $percentage; ?>%</span>
                <div class="w-24 h-2.5 bg-gray-200 rounded-full overflow-hidden">
                    <div id="progress-bar" class="h-full bg-green-500 transition-all duration-700" style="width: <?php echo $percentage; ?>%"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Conteúdo Principal -->
    <div class="container mx-auto max-w-3xl p-4 mt-8">
        
        <div class="text-center mb-12 animate-up" style="animation-delay: 0s;">
            <h1 class="text-3xl font-extrabold text-green-900 mb-2">Seu Plano de Voo 🚀</h1>
            <p class="text-gray-500">Siga as etapas abaixo para decolarmos juntos.</p>
        </div>

        <div class="space-y-12">
            <?php 
            $delay = 0.1;
            $week_count = 0;
            $total_weeks = count($weeks_data);
            
            foreach ($weeks_data as $week_num => $week): 
                $week_count++;
                $is_last_week = ($week_count === $total_weeks);
                $delay += 0.1;
            ?>
            
            <div class="relative pl-12 sm:pl-14 animate-up <?php echo $is_last_week ? 'last-item' : ''; ?>" style="animation-delay: <?php echo $delay; ?>s">
                
                <!-- Indicador da Semana (Bolinha) -->
                <div class="absolute left-0 top-0 w-10 h-10 bg-white border-4 border-green-500 rounded-full flex items-center justify-center shadow-sm z-10 font-bold text-green-700 text-sm">
                    <?php echo $week_num; ?>
                </div>
                
                <!-- Linha Conectora -->
                <div class="timeline-connector"></div>

                <!-- Título da Semana -->
                <h2 class="text-xl font-bold text-gray-900 mb-6 pt-1"><?php echo htmlspecialchars($week['title']); ?></h2>

                <!-- Lista de Tópicos e Tarefas -->
                <div class="space-y-6">
                    <?php foreach ($week['topics'] as $topic_title => $tasks): ?>
                        
                        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                            <!-- Cabeçalho do Tópico -->
                            <div class="bg-gray-50 px-5 py-3 border-b border-gray-100 flex items-center gap-2">
                                <span class="w-2 h-2 rounded-full bg-green-400"></span>
                                <h3 class="font-bold text-gray-700 text-sm uppercase tracking-wide">
                                    <?php echo htmlspecialchars($topic_title); ?>
                                </h3>
                            </div>

                            <!-- Lista de Tarefas deste Tópico -->
                            <div class="divide-y divide-gray-100">
                                <?php foreach ($tasks as $task): 
                                    $is_client = ($task['responsible'] === 'client');
                                    $is_done = !empty($task['completed_at']);
                                    $row_class = $is_done ? 'bg-green-50/50' : 'hover:bg-gray-50';
                                ?>
                                <div class="p-5 <?php echo $row_class; ?> task-row transition-colors" data-task-id="<?php echo $task['id']; ?>">
                                    <div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-4">
                                        
                                        <!-- Info da Tarefa -->
                                        <div class="flex-1">
                                            <div class="flex items-center gap-2 mb-1">
                                                <h4 class="font-semibold text-gray-900 <?php echo $is_done ? 'line-through text-gray-400' : ''; ?>">
                                                    <?php echo htmlspecialchars($task['name']); ?>
                                                </h4>
                                                <?php if (!$is_client): ?>
                                                    <span class="bg-gray-100 text-gray-500 text-[10px] font-bold px-2 py-0.5 rounded-full border border-gray-200">SMAIS</span>
                                                <?php elseif (!$is_done): ?>
                                                    <span class="bg-yellow-50 text-yellow-700 text-[10px] font-bold px-2 py-0.5 rounded-full border border-yellow-200">SUA VEZ</span>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <p class="text-sm text-gray-500 leading-relaxed <?php echo $is_done ? 'opacity-50' : ''; ?>">
                                                <?php echo htmlspecialchars($task['description']); ?>
                                            </p>
                                            
                                            <?php if ($is_done): ?>
                                                <div class="mt-2 text-xs font-medium text-green-600 flex items-center gap-1">
                                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                                    Concluído em <?php echo date('d/m/Y', strtotime($task['completed_at'])); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>

                                        <!-- Botões de Ação -->
                                        <div class="flex items-center gap-3 shrink-0">
                                            <?php if (!empty($task['url'])): ?>
                                                <a href="<?php echo $task['url']; ?>" target="_blank" 
                                                   class="btn-action flex items-center gap-2 px-3 py-2 text-xs font-medium text-gray-600 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 hover:text-green-700">
                                                   <span>Acessar</span>
                                                   <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path></svg>
                                                </a>
                                            <?php endif; ?>

                                            <?php if ($is_client && !$is_done): ?>
                                                <button onclick="markDone(this, <?php echo $task['id']; ?>)"
                                                        class="btn-action px-4 py-2 text-xs font-bold text-white bg-green-600 hover:bg-green-700 rounded-lg shadow-sm shadow-green-200 transition-colors flex items-center gap-1">
                                                    Marcar Feito
                                                </button>
                                            <?php endif; ?>
                                        </div>

                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>

                    <?php endforeach; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Overlay de Comemoração -->
    <div id="completion-overlay" class="fixed inset-0 bg-black/80 z-[60] flex items-center justify-center hidden backdrop-blur-sm">
        <div class="bg-white p-8 rounded-2xl shadow-2xl max-w-md w-full text-center mx-4 transform transition-all scale-95 opacity-0" id="modal-card">
            <div class="text-6xl mb-4 animate-bounce">🏆</div>
            <h2 class="text-2xl font-bold text-gray-900 mb-2">Missão Cumprida!</h2>
            <p class="text-gray-600 mb-6">Você finalizou todas as suas etapas do onboarding. Nossa equipe já foi notificada! 🚀</p>
            <button onclick="closeOverlay()" class="w-full py-3 bg-green-600 hover:bg-green-700 text-white font-bold rounded-xl transition-colors shadow-lg shadow-green-200">
                Maravilha!
            </button>
        </div>
    </div>

    <!-- Toast Notification -->
    <div id="toast" class="fixed bottom-6 left-1/2 -translate-x-1/2 bg-gray-800 text-white px-4 py-2 rounded-lg shadow-xl text-sm font-medium hidden z-[70] flex items-center gap-2">
        <span id="toast-msg"></span>
    </div>

    <script>
        const CLIENT_ID = <?php echo $client_id; ?>;
        const CLIENT_SLUG = "<?php echo $client_slug; ?>";
        let totalTasks = <?php echo $total_client_tasks; ?>;
        let doneTasks = <?php echo $total_client_completed; ?>;

        async function markDone(btn, taskId) {
            // UI Feedback Imediato
            const originalText = btn.innerHTML;
            btn.disabled = true;
            btn.innerHTML = '<svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>';
            btn.classList.add('opacity-75');

            try {
                const res = await fetch(`index.php?client=${CLIENT_SLUG}`, {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({ client_id: CLIENT_ID, task_id: taskId })
                });
                const data = await res.json();

                if (data.success) {
                    // Confete
                    confetti({ particleCount: 40, spread: 50, origin: { y: 0.7 }, colors: ['#22c55e', '#16a34a'] });

                    // Atualiza o visual da linha
                    const row = btn.closest('.task-row');
                    row.classList.add('bg-green-50/50');
                    row.classList.remove('hover:bg-gray-50');
                    
                    // Atualiza título e remove badge
                    const title = row.querySelector('h4');
                    title.classList.add('line-through', 'text-gray-400');
                    
                    // Remove botão e adiciona texto de concluído
                    const actionDiv = btn.parentNode;
                    btn.remove();
                    const dateSpan = document.createElement('div');
                    dateSpan.className = 'text-xs font-bold text-green-600 flex items-center gap-1 bg-green-100 px-2 py-1 rounded';
                    dateSpan.innerHTML = '✓ Feito';
                    actionDiv.appendChild(dateSpan);

                    // Progresso
                    doneTasks++;
                    updateProgress();

                } else {
                    showToast(data.message || 'Erro ao salvar', true);
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                    btn.classList.remove('opacity-75');
                }
            } catch (e) {
                console.error(e);
                showToast('Erro de conexão', true);
                btn.innerHTML = originalText;
                btn.disabled = false;
                btn.classList.remove('opacity-75');
            }
        }

        function updateProgress() {
            const pct = totalTasks > 0 ? Math.round((doneTasks / totalTasks) * 100) : 0;
            document.getElementById('progress-bar').style.width = pct + '%';
            document.getElementById('progress-text').innerText = pct + '%';

            if (pct === 100) {
                setTimeout(openOverlay, 1000);
            }
        }

        function openOverlay() {
            const overlay = document.getElementById('completion-overlay');
            const card = document.getElementById('modal-card');
            overlay.classList.remove('hidden');
            
            // Animação de entrada
            setTimeout(() => {
                card.classList.remove('scale-95', 'opacity-0');
                card.classList.add('scale-100', 'opacity-100');
            }, 10);

            // Chuva de confetes
            const end = Date.now() + 3000;
            (function frame() {
                confetti({ particleCount: 4, angle: 60, spread: 55, origin: { x: 0 } });
                confetti({ particleCount: 4, angle: 120, spread: 55, origin: { x: 1 } });
                if (Date.now() < end) requestAnimationFrame(frame);
            }());
        }

        function closeOverlay() {
            const overlay = document.getElementById('completion-overlay');
            overlay.classList.add('hidden');
        }

        function showToast(msg, isError = false) {
            const t = document.getElementById('toast');
            const m = document.getElementById('toast-msg');
            t.className = `fixed bottom-6 left-1/2 -translate-x-1/2 px-4 py-2 rounded-lg shadow-xl text-sm font-medium z-[70] flex items-center gap-2 ${isError ? 'bg-red-600 text-white' : 'bg-gray-800 text-white'}`;
            m.innerText = msg;
            t.classList.remove('hidden');
            setTimeout(() => t.classList.add('hidden'), 3000);
        }
    </script>
</body>
</html>